	function X = PZ_2_X_PARAMETERS(G, Z, P)

	% 	Converts poles and zeros to X parameters for optimization 
	%	where
	%	X(1) = G
	% 	X(2...Nz) = a1n a2n ....
	% 	X(Nz+1...Nz+Np+1) = -b1n -b2n ....
	% 	Nz = number of zeros and Np number of poles
	% 	and
	%			 Prod(z^2 + a1n z + a2n)
	%	H(z) = G _____________________
	%             Prod(z2 -b1n z - b2n)

	% 	Toolbox for DIGITAL FILTERS USING MATLAB
 
	% 	Author: 		Lars Wanhammar 2010-10-12
	% 	Modified by: 	 	
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:			 
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com

	global p Des wT Nz Np 

	X(1) = G;
	Z = cplxpair(Z);
	for k = 1:2:Nz-mod(Nz, 2)-1
		X(k+1) = -real(Z(k)+Z(k+1));
		X(k+2) = real(Z(k)*Z(k+1));
	end
	if mod(Nz, 2) == 1
		X(Nz+1) = Z(Nz);
	end	
	P = cplxpair(P);
	for k = 1:2:Np-mod(Np, 2)-1
		X(k+Nz+1) = real(P(k)+P(k+1));
		X(k+Nz+2) = -real(P(k)*P(k+1));
	end
	if mod(Np, 2) == 1
		X(Np+Nz+1) = -P(Np);
	end
	return
